/*Copyright (c) 2015-2016 wavemaker-com All Rights Reserved.
 This software is the confidential and proprietary information of wavemaker-com You shall not disclose such Confidential Information and shall use it only in accordance
 with the terms of the source code license agreement you entered into with wavemaker-com*/
package com.todo.todo.service;

/*This is a Studio Managed File. DO NOT EDIT THIS FILE. Your changes may be reverted by Studio.*/

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

import com.wavemaker.runtime.data.dao.WMGenericDao;
import com.wavemaker.runtime.data.exception.EntityNotFoundException;
import com.wavemaker.runtime.data.export.ExportType;
import com.wavemaker.runtime.data.expression.QueryFilter;
import com.wavemaker.runtime.data.model.AggregationInfo;
import com.wavemaker.runtime.file.model.Downloadable;

import com.todo.todo.Todo;


/**
 * ServiceImpl object for domain model class Todo.
 *
 * @see Todo
 */
@Service("ToDo.TodoService")
@Validated
public class TodoServiceImpl implements TodoService {

    private static final Logger LOGGER = LoggerFactory.getLogger(TodoServiceImpl.class);


    @Autowired
    @Qualifier("ToDo.TodoDao")
    private WMGenericDao<Todo, Integer> wmGenericDao;

    public void setWMGenericDao(WMGenericDao<Todo, Integer> wmGenericDao) {
        this.wmGenericDao = wmGenericDao;
    }

    @Transactional(value = "ToDoTransactionManager")
    @Override
	public Todo create(Todo todo) {
        LOGGER.debug("Creating a new Todo with information: {}", todo);
        Todo todoCreated = this.wmGenericDao.create(todo);
        return todoCreated;
    }

	@Transactional(readOnly = true, value = "ToDoTransactionManager")
	@Override
	public Todo getById(Integer todoId) throws EntityNotFoundException {
        LOGGER.debug("Finding Todo by id: {}", todoId);
        Todo todo = this.wmGenericDao.findById(todoId);
        if (todo == null){
            LOGGER.debug("No Todo found with id: {}", todoId);
            throw new EntityNotFoundException(String.valueOf(todoId));
        }
        return todo;
    }

    @Transactional(readOnly = true, value = "ToDoTransactionManager")
	@Override
	public Todo findById(Integer todoId) {
        LOGGER.debug("Finding Todo by id: {}", todoId);
        return this.wmGenericDao.findById(todoId);
    }


	@Transactional(rollbackFor = EntityNotFoundException.class, value = "ToDoTransactionManager")
	@Override
	public Todo update(Todo todo) throws EntityNotFoundException {
        LOGGER.debug("Updating Todo with information: {}", todo);
        this.wmGenericDao.update(todo);

        Integer todoId = todo.getId();

        return this.wmGenericDao.findById(todoId);
    }

    @Transactional(value = "ToDoTransactionManager")
	@Override
	public Todo delete(Integer todoId) throws EntityNotFoundException {
        LOGGER.debug("Deleting Todo with id: {}", todoId);
        Todo deleted = this.wmGenericDao.findById(todoId);
        if (deleted == null) {
            LOGGER.debug("No Todo found with id: {}", todoId);
            throw new EntityNotFoundException(String.valueOf(todoId));
        }
        this.wmGenericDao.delete(deleted);
        return deleted;
    }

	@Transactional(readOnly = true, value = "ToDoTransactionManager")
	@Override
	public Page<Todo> findAll(QueryFilter[] queryFilters, Pageable pageable) {
        LOGGER.debug("Finding all Todos");
        return this.wmGenericDao.search(queryFilters, pageable);
    }

    @Transactional(readOnly = true, value = "ToDoTransactionManager")
    @Override
    public Page<Todo> findAll(String query, Pageable pageable) {
        LOGGER.debug("Finding all Todos");
        return this.wmGenericDao.searchByQuery(query, pageable);
    }

    @Transactional(readOnly = true, value = "ToDoTransactionManager")
    @Override
    public Downloadable export(ExportType exportType, String query, Pageable pageable) {
        LOGGER.debug("exporting data in the service ToDo for table Todo to {} format", exportType);
        return this.wmGenericDao.export(exportType, query, pageable);
    }

	@Transactional(readOnly = true, value = "ToDoTransactionManager")
	@Override
	public long count(String query) {
        return this.wmGenericDao.count(query);
    }

    @Transactional(readOnly = true, value = "ToDoTransactionManager")
	@Override
    public Page<Map<String, Object>> getAggregatedValues(AggregationInfo aggregationInfo, Pageable pageable) {
        return this.wmGenericDao.getAggregatedValues(aggregationInfo, pageable);
    }



}

